package com.livescribe.samples;

import com.livescribe.penlet.Penlet;
import com.livescribe.ui.MediaPlayer;
import com.livescribe.penlet.Region;
import com.livescribe.afp.PageInstance;
import com.livescribe.event.PenTipListener;
import com.livescribe.ext.util.Log;

/**
 * Sample tap and play penlet
 * 
 * The behavior of this penlet depends on the resources included in the penlet.
 * Please review the files in the RES folder.  The audio files, image files, 
 * and text strings included in the RES folder will dictate what happens when
 * an area is tapped.
 * 
 * For example:
 *   The Earth region has an audio resource, a text resource, and an image resource.
 *   Therefore, all 3 resources are used when the Earth region is tapped.
 *   Saturn has text.
 *   Venus has text and an image.
 *   Jupiter has an image.
 *   The help region has text and audio.
 *   The sound region has audio only.
 */
public class TapAndPlayPenlet extends Penlet implements PenTipListener {
    private TapAndPlayHelper tapAndPlayHelper;

    public TapAndPlayPenlet() {   
    }

    /**
     * Invoked when the application is initialized.  This happens once for an application instance.
     */
    public void initApp() {
    	Log.setLogger(this.logger);	// set the logger so the helper will have access if needed
        this.tapAndPlayHelper = new TapAndPlayHelper(context, MediaPlayer.newInstance(this));
    }
    
    /**
     * Invoked each time the penlet is activated.  Only one penlet is active at any given time.
     */
    public void activateApp(int reason, Object[] args) {
		context.addPenTipListener(this);
    }
    
    /**
     * Invoked when the application is deactivated.
     */
    public void deactivateApp(int reason) {
		context.removePenTipListener(this);
    }
    
    /**
     * Invoked when the application is destroyed.  This happens once for an application instance.  
     * No other methods will be invoked on the instance after destroyApp is called.
     */
    public void destroyApp() {
    }

	public void penUp(long time, Region region, PageInstance page) {
	
	}

	public void penDown(long time, Region region, PageInstance page) {
		if (!penDownEventDelegator(time, region, page)) {
			tapAndPlayHelper.processPenEvent(region, page);			
		}
	}

	public void singleTap(long time, int x, int y) {
	
	}

	public void doubleTap(long time, int x, int y) {
	
	}

	// *** GENERATED METHOD -- DO NOT MODIFY ***
	/**
	 * Responsible for delegating generic PEN_DOWN events to area specific pen down methods based upon the area in which
	 * they occurred. This method is generated and managed by the penlet project nature. Users should modify the
	 * individual area event handlers (e.g. on<AreaName>PenDown) or the generic event handler (e.g. penDown)).
	
	 * @param time The time at which the event occurred
	 * @param region The region in which the event occurred
	 * @param page The page on which the event occurred
	 * @return true if the event was successfully handled, false otherwise
	 */
	protected boolean penDownEventDelegator(long time, Region region, PageInstance page) {
		boolean eventHandled = true;
		switch (region.getAreaId()) {
		default:
			eventHandled = false;
		}
		return eventHandled;
	}
	// *** END OF GENERATED CODE ***


}
