/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.util;

import java.io.File;
import java.io.IOException;

public class MkDirsFor {
    private static final String CLASS_NAME = "MkDirsFor";

    private MkDirsFor() {
    }

    private static void printUsage() {
        System.out.println("Usage: MkDirsFor [-v] (file)*");
    }

    public static void main(String[] args) throws IOException {
        boolean verbose = false;
        for (int index = 0; index < args.length && args[index].startsWith("-"); ++index) {
            if ("-v".equals(args[index])) {
                verbose = true;
                continue;
            }
            MkDirsFor.printUsage();
            System.exit(1);
        }
        for (int i = index; i < args.length; ++i) {
            File file = new File(args[i]);
            if (!file.exists()) {
                if ((file = file.getParentFile()) != null) {
                    if (!file.exists()) {
                        if (verbose) {
                            System.out.println("Creating parent dirs for '" + args[i] + "'...");
                        }
                        if (file.mkdirs()) continue;
                        throw new IOException("Failed to create parent directories for '" + args[i] + "'");
                    }
                    if (!verbose) continue;
                    System.out.println("Parent dirs already exist for '" + args[i] + "'.");
                    continue;
                }
                if (!verbose) continue;
                System.out.println("Error getting parent of '" + args[i] + "'!");
                continue;
            }
            if (!verbose) continue;
            System.out.println("'" + args[i] + "' already exists.");
        }
    }
}

