/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.image;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ARWEncoder {
    private static final String CLASS_NAME = "ARWEncoder";

    private ARWEncoder() {
    }

    private static void printUsage() {
        System.out.println("Usage: ARWEncoder [-v] [-t <luma threashold>] <in> <out>");
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img;
        String arg;
        int index;
        boolean verbose = false;
        double lumaThreshold = 0.0;
        for (index = 0; index < args.length && (arg = args[index]).startsWith("-"); ++index) {
            if ("-v".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("-t".equals(arg)) {
                try {
                    lumaThreshold = Double.parseDouble(args[++index]);
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    break;
                }
            }
            ARWEncoder.printUsage();
            System.exit(1);
        }
        if (index + 2 > args.length) {
            ARWEncoder.printUsage();
            System.exit(1);
        }
        if (verbose) {
            System.out.println("Converting '" + args[index] + "' -> '" + args[index + 1] + "'...");
        }
        if ((img = ImageIO.read(new File(args[index]))) == null) {
            throw new IOException("Can't read '" + args[index] + "'");
        }
        int width = img.getWidth();
        int height = img.getHeight();
        if (width > 255 || height > 255) {
            throw new IOException("Image '" + args[index] + "' dimension(s) greater than 255x255");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(args[index + 1]));
        out.write(65);
        out.write(82);
        out.write(87);
        out.write(1);
        out.write(width);
        out.write(height);
        for (int y = 0; y < height; ++y) {
            int currData = 0;
            for (int x = 0; x < width; ++x) {
                currData <<= 1;
                int aRGB = img.getRGB(x, y);
                double luma = ((double)(aRGB >> 16 & 0xFF) * 0.2126 + (double)(aRGB >> 8 & 0xFF) * 0.7152 + (double)(aRGB & 0xFF) * 0.0722) / 255.0;
                if (luma > 1.0) {
                    luma = 1.0;
                }
                if (luma > lumaThreshold) {
                    currData |= 1;
                }
                if ((x & 7) != 7) continue;
                out.write(currData);
                currData = 0;
            }
            int rem = width & 7;
            if (rem == 0) continue;
            out.write(currData << 8 - rem);
        }
        out.flush();
        out.close();
    }
}

