/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.audio;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;

public class IfSamplingRateGreater {
    private static final String CLASS_NAME = "IfSamplingRateGreater";
    private static final byte[] CHUNK_ID = new byte[]{82, 73, 70, 70};
    private static final int CHUNK_ID_INDEX = 0;
    private static final byte[] FORMAT = new byte[]{87, 65, 86, 69};
    private static final int FORMAT_INDEX = 8;
    private static final byte[] SUBCHUNK1_ID = new byte[]{102, 109, 116, 32};
    private static final int SUBCHUNK1_ID_INDEX = 12;

    private IfSamplingRateGreater() {
    }

    private static void printUsage() {
        System.out.println("Usage: IfSamplingRateGreater <max-sampling-rate> (file)*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            IfSamplingRateGreater.printUsage();
            System.exit(1);
        }
        int maxSamplingRate = Integer.parseInt(args[0]);
        byte[] buf = new byte[28];
        for (int i = 1; i < args.length; ++i) {
            File file = new File(args[i]);
            if (file.length() < 28L) continue;
            FilterInputStream in = null;
            try {
                int samplingRate;
                in = new DataInputStream(new FileInputStream(file));
                ((DataInputStream)in).readFully(buf);
                if (!IfSamplingRateGreater.compare(buf, 0, CHUNK_ID, 0, CHUNK_ID.length) || !IfSamplingRateGreater.compare(buf, 8, FORMAT, 0, FORMAT.length) || !IfSamplingRateGreater.compare(buf, 12, SUBCHUNK1_ID, 0, SUBCHUNK1_ID.length) || (samplingRate = buf[24] & 0xFF | (buf[25] & 0xFF) << 8 | (buf[26] & 0xFF) << 16 | (buf[27] & 0xFF) << 24) <= maxSamplingRate) continue;
                System.out.println(args[i]);
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (EOFException ex) {
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    private static boolean compare(byte[] b1, int off1, byte[] b2, int off2, int len) {
        if (off1 + len > b1.length || off2 + len > b2.length) {
            return false;
        }
        int i = len;
        while (--i >= 0) {
            if (b1[off1 + i] == b2[off2 + i]) continue;
            return false;
        }
        return true;
    }
}

