/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.util;

import com.livescribe.ext.util.Cloneable;
import com.livescribe.ext.util.Collection;
import com.livescribe.ext.util.Comparable;
import com.livescribe.ext.util.Iterator;
import com.livescribe.ext.util.Queue;
import java.util.Enumeration;

public class PriorityQueue
implements Cloneable,
Queue {
    private Object[] heap;
    private int size;

    public PriorityQueue() {
        this.clear();
    }

    public PriorityQueue(int n) {
        this.heap = new Object[n];
    }

    public PriorityQueue(Collection collection) {
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.offer(object);
        }
    }

    public PriorityQueue(Enumeration enumeration) {
        this.clear();
        while (enumeration.hasMoreElements()) {
            this.offer(enumeration.nextElement());
        }
    }

    public PriorityQueue(Object[] objectArray) {
        this.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            this.offer(objectArray[i]);
        }
    }

    public boolean add(Object object) {
        return this.offer(object);
    }

    public void clear() {
        this.heap = new Object[4];
        this.size = 0;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.heap[i])) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        QueueIterator queueIterator = new QueueIterator(this);
        return queueIterator;
    }

    private void checkSize() {
        int n;
        if (this.size == this.heap.length) {
            n = this.heap.length < 256 ? this.heap.length * 2 : this.heap.length + 256;
        } else if (this.size + 512 < this.heap.length) {
            n = this.heap.length - 256;
        } else {
            return;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.heap, 0, objectArray, 0, this.size);
        this.heap = objectArray;
    }

    private void swap(int n, int n2) {
        Object object = this.heap[n];
        this.heap[n] = this.heap[n2];
        this.heap[n2] = object;
    }

    public boolean offer(Object object) {
        int n = this.size;
        if (!(object instanceof Comparable)) {
            return false;
        }
        this.checkSize();
        this.heap[n] = object;
        while (n > 0 && ((Comparable)this.heap[n]).compareTo(this.heap[n - 1 >> 1]) > 0) {
            int n2 = n - 1 >> 1;
            this.swap(n, n2);
            n = n2;
        }
        ++this.size;
        return true;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.heap[0];
    }

    private Object removeAtIndex(int n) {
        Object object = this.heap[n];
        if (this.size == 0) {
            return null;
        }
        --this.size;
        this.heap[n] = this.heap[this.size];
        int n2 = n;
        while (n2 >= 0) {
            int n3 = n2 * 2;
            if (n3 + 2 > this.size || ((Comparable)this.heap[n3 + 1]).compareTo(this.heap[n3 + 2]) > 0) {
                if (n3 + 1 > this.size) break;
                ++n3;
            } else {
                n3 += 2;
            }
            if (((Comparable)this.heap[n2]).compareTo(this.heap[n3]) < 0) {
                this.swap(n2, n3);
                n2 = n3;
                continue;
            }
            n2 = -1;
        }
        this.checkSize();
        return object;
    }

    public Object poll() {
        return this.removeAtIndex(0);
    }

    public Object element() {
        return this.peek();
    }

    public Object remove() {
        return this.poll();
    }

    public boolean remove(Object object) {
        int n;
        for (n = 0; n < this.size && !this.heap[n].equals(object); ++n) {
        }
        if (n == this.size) {
            return false;
        }
        this.removeAtIndex(n);
        return true;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.heap.length];
        System.arraycopy(this.heap, 0, objectArray, 0, this.heap.length);
        return objectArray;
    }

    public Object clone() {
        PriorityQueue priorityQueue = new PriorityQueue();
        priorityQueue.heap = new Object[this.heap.length];
        System.arraycopy(this.heap, 0, priorityQueue.heap, 0, this.heap.length);
        priorityQueue.size = this.size;
        return priorityQueue;
    }

    public boolean addAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.offer(iterator.next());
        }
        return true;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (collection.contains(object)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    private class QueueIterator
    implements Iterator {
        private PriorityQueue queue;
        private int location = 0;

        public QueueIterator(PriorityQueue priorityQueue2) {
            this.queue = priorityQueue2;
        }

        public boolean hasNext() {
            return this.location < this.queue.size;
        }

        public Object next() {
            if (this.location >= PriorityQueue.this.size) {
                return null;
            }
            return this.queue.heap[this.location++];
        }

        public void remove() {
            this.queue.removeAtIndex(this.location);
        }
    }
}

