/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.util;

public class Lock {
    private Thread owner;

    public synchronized void acquireLock() throws InterruptedException {
        if (this.owner == Thread.currentThread()) {
            return;
        }
        while (this.owner != null) {
            this.wait();
        }
        this.owner = Thread.currentThread();
    }

    public synchronized boolean acquireLock(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout: " + l);
        }
        if (l == 0L) {
            this.acquireLock();
            return true;
        }
        if (this.owner == Thread.currentThread()) {
            return true;
        }
        long l2 = System.currentTimeMillis() + l;
        while (this.owner != null && (l = l2 - System.currentTimeMillis()) > 0L) {
            this.wait(l);
        }
        if (this.owner != null) {
            return false;
        }
        this.owner = Thread.currentThread();
        return true;
    }

    public synchronized void releaseLock() {
        if (this.owner == Thread.currentThread()) {
            this.owner = null;
            this.notifyAll();
        }
    }
}

