/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.util;

import com.livescribe.ext.util.Cloneable;
import com.livescribe.ext.util.Collection;
import com.livescribe.ext.util.Comparable;
import com.livescribe.ext.util.Iterator;
import com.livescribe.ext.util.List;
import com.livescribe.ext.util.ListIterator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LinkedList
implements Cloneable,
List {
    private int size;
    private Node head;

    public LinkedList() {
        this.clear();
    }

    public LinkedList(Collection collection) {
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.addLast(object);
        }
    }

    public LinkedList(Enumeration enumeration) {
        this.clear();
        while (enumeration.hasMoreElements()) {
            this.addLast(enumeration.nextElement());
        }
    }

    public LinkedList(Object[] objectArray) {
        this.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            this.offer(objectArray[i]);
        }
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.head.succ;
        while (n-- > 0) {
            node = node.succ;
        }
        ++this.size;
        node.InsertBefore(new Node(object));
    }

    public boolean add(Object object) {
        ++this.size;
        this.head.InsertBefore(new Node(object));
        return true;
    }

    public boolean addAll(Collection collection) {
        int n = collection.size();
        boolean bl = false;
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            Object object = iterator.next();
            this.addLast(object);
            bl = true;
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object[] objectArray = collection.toArray();
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.add(n++, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!this.remove(object)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (collection.contains(object)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void addFirst(Object object) {
        ++this.size;
        this.head.succ.InsertBefore(new Node(object));
    }

    public void addLast(Object object) {
        ++this.size;
        this.head.InsertBefore(new Node(object));
    }

    public void offer(Object object) {
        this.addLast(object);
    }

    public void clear() {
        this.head = new Node(null);
        this.size = 0;
    }

    public Object clone() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            linkedList.addLast(iterator.next());
        }
        return linkedList;
    }

    public boolean contains(Object object) {
        Node node = this.head.succ;
        for (int i = 0; i < this.size; ++i) {
            if (object == null && node.data == null || node.data.equals(object)) {
                return true;
            }
            node = node.succ;
        }
        return false;
    }

    public Object get(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.head.succ;
        while (n-- > 0) {
            node = node.succ;
        }
        return node.data;
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.head.succ.data;
    }

    public Object peek() {
        return this.head.succ.data;
    }

    public Object element() {
        return this.head.succ.data;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.head.pred.data;
    }

    public int indexOf(Object object) {
        Node node = this.head.succ;
        for (int i = 0; i < this.size; ++i) {
            if (object == null && node.data == null || node.data.equals(object)) {
                return i;
            }
            node = node.succ;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        Node node = this.head.pred;
        for (int i = 0; i < this.size; ++i) {
            if (object == null && node.data == null || node.data.equals(object)) {
                return this.size - i - 1;
            }
            node = node.pred;
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        return new LinkedListIterator(n);
    }

    public Object remove(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.head.succ;
        while (n-- > 0) {
            node = node.succ;
        }
        --this.size;
        return node.Remove().data;
    }

    public boolean remove(Object object) {
        Node node = this.head.succ;
        for (int i = 0; i < this.size; ++i) {
            if (node.data == object) {
                node.Remove();
                --this.size;
                return true;
            }
            node = node.succ;
        }
        return false;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.head.succ.Remove().data;
        --this.size;
        return object;
    }

    public Object remove() {
        return this.removeFirst();
    }

    public Object poll() {
        if (this.size == 0) {
            return null;
        }
        Object object = this.head.succ.Remove().data;
        --this.size;
        return object;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        return this.head.pred.Remove().data;
    }

    public Object set(int n, Object object) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.head.succ;
        while (n-- > 0) {
            node = node.succ;
        }
        Object object2 = node.data;
        node.data = object;
        return object2;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        Node node = this.head.succ;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = node.data;
            node = node.succ;
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)object;
        Iterator iterator = this.iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object object2 = iterator.next();
            Object object3 = iterator2.next();
            if (object2 == null && object3 == null || object2.equals(object3)) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new LinkedListIterator(0);
    }

    public ListIterator listIterator() {
        return new LinkedListIterator(0);
    }

    public List subList(int n, int n2) {
        LinkedList linkedList = new LinkedList();
        LinkedListIterator linkedListIterator = new LinkedListIterator(n);
        n2 -= n;
        while (linkedListIterator.hasNext() && n2-- > 0) {
            linkedList.addLast(linkedListIterator.next());
        }
        return linkedList;
    }

    public void sort() {
        if (this.size < 2) {
            return;
        }
        LinkedList linkedList = (LinkedList)this.subList(0, this.size >> 1);
        LinkedList linkedList2 = (LinkedList)this.subList(this.size >> 1, this.size);
        linkedList.sort();
        linkedList2.sort();
        this.clear();
        LinkedListIterator linkedListIterator = linkedList.new LinkedListIterator();
        LinkedListIterator linkedListIterator2 = linkedList2.new LinkedListIterator();
        Object object = linkedListIterator.next();
        Object object2 = linkedListIterator2.next();
        while (linkedListIterator.hasNext() && linkedListIterator2.hasNext()) {
            if (((Comparable)object).compareTo(object2) > 0) {
                this.addLast(object);
                object = linkedListIterator.next();
                continue;
            }
            this.addLast(object2);
            object2 = linkedListIterator2.next();
        }
        while (linkedListIterator.hasNext()) {
            if (object2 == null || ((Comparable)object).compareTo(object2) > 0) {
                this.addLast(object);
                object = linkedListIterator.next();
                continue;
            }
            this.add(object2);
            object2 = null;
        }
        while (linkedListIterator2.hasNext()) {
            if (object == null || ((Comparable)object2).compareTo(object) > 0) {
                this.addLast(object2);
                object2 = linkedListIterator2.next();
                continue;
            }
            this.add(object);
            object = null;
        }
        if (object != null && object2 != null) {
            if (((Comparable)object).compareTo(object2) > 0) {
                this.addLast(object);
                object = null;
            } else {
                this.addLast(object2);
                object2 = null;
            }
        }
        if (object2 != null) {
            this.add(object2);
        }
        if (object != null) {
            this.add(object);
        }
    }

    private class LinkedListIterator
    implements Iterator,
    ListIterator {
        private Node curr;
        private int location;

        public LinkedListIterator() {
            this.location = 0;
            this.curr = LinkedList.this.head;
        }

        public LinkedListIterator(int n) {
            if (n < 0 || n > LinkedList.this.size) {
                throw new IndexOutOfBoundsException();
            }
            this.location = n;
            this.curr = LinkedList.this.head;
            while (n-- > 0) {
                this.curr = this.curr.succ;
            }
        }

        public void add(Object object) {
            this.curr.InsertBefore(new Node(object));
            LinkedList.this.size++;
            ++this.location;
        }

        public boolean hasNext() {
            return this.curr.succ != LinkedList.this.head;
        }

        public boolean hasPrevious() {
            return this.curr != LinkedList.this.head;
        }

        public Object next() {
            if (this.curr.succ == LinkedList.this.head) {
                throw new NoSuchElementException();
            }
            this.curr = this.curr.succ;
            this.location = (this.location + 1) % LinkedList.this.size;
            return this.curr.data;
        }

        public int nextIndex() {
            return this.location;
        }

        public Object previous() {
            if (this.curr == LinkedList.this.head) {
                throw new NoSuchElementException();
            }
            this.curr = this.curr.pred;
            this.location = (this.location - 1) % LinkedList.this.size;
            return this.curr.data;
        }

        public int previousIndex() {
            return this.location - 1;
        }

        public void remove() {
            this.curr.Remove();
            LinkedList.this.size--;
            --this.location;
        }

        public void set(Object object) {
            this.curr.data = object;
        }
    }

    private class Node {
        protected Node succ;
        protected Node pred;
        protected Object data;

        public Node(Object object) {
            this.data = object;
            this.succ = this;
            this.pred = this;
        }

        public Node(Node node, Node node2, Object object) {
            this.data = object;
            this.succ = node;
            this.pred = node2;
        }

        public void InsertBefore(Node node) {
            this.pred.succ = node;
            node.pred = this.pred;
            node.succ = this;
            this.pred = node;
        }

        public Node Remove() {
            Node node = this;
            this.succ.pred = this.pred;
            this.pred.succ = this.succ;
            return node;
        }
    }
}

