/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.util;

public class Latch {
    private boolean state;

    public synchronized void setLatch() {
        if (!this.state) {
            this.state = true;
            this.notifyAll();
        }
    }

    public synchronized void waitLatch() throws InterruptedException {
        while (!this.state) {
            this.wait();
        }
    }

    public synchronized boolean waitLatch(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout: " + l);
        }
        if (l == 0L) {
            this.waitLatch();
            return true;
        }
        long l2 = System.currentTimeMillis() + l;
        while (!this.state && (l = l2 - System.currentTimeMillis()) > 0L) {
            this.wait(l);
        }
        return this.state;
    }

    public synchronized boolean isSet() {
        return this.state;
    }

    public synchronized boolean setIfNotSet() {
        if (!this.state) {
            this.state = true;
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized void resetLatch() {
        this.state = false;
    }
}

