/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.ui;

import com.livescribe.display.Canvas;
import com.livescribe.display.Graphics;
import com.livescribe.display.Image;
import java.util.Vector;

public class SlotMachine
extends Canvas {
    private int startX;
    private Vector reelsAndSeps;
    private Vector reelMap;

    public SlotMachine() {
        this(0);
    }

    public SlotMachine(int n) {
        this.startX = n;
        this.reelsAndSeps = new Vector();
        this.reelMap = new Vector();
    }

    public void addReel(Image[] imageArray) {
        this.addReel(imageArray, null);
    }

    public void addReel(Image[] imageArray, Image[] imageArray2) {
        if (imageArray2 != null && imageArray2.length != imageArray.length) {
            throw new IllegalArgumentException();
        }
        this.reelMap.addElement(new Integer(this.reelsAndSeps.size()));
        this.reelsAndSeps.addElement(new Reel(imageArray, imageArray2));
    }

    public void addSeparator(Image image) {
        this.reelsAndSeps.addElement(image);
    }

    private Reel getReel(int n) {
        int n2 = (Integer)this.reelMap.elementAt(n);
        return (Reel)this.reelsAndSeps.elementAt(n2);
    }

    public float getReelPosition(int n) {
        Reel reel = this.getReel(n);
        return SlotMachine.mod(reel.currPosition, reel.itemCount);
    }

    public int getReelCount() {
        return this.reelMap.size();
    }

    public void setReelPosition(int n, float f) {
        this.getReel((int)n).currPosition = f;
    }

    public void moveReel(int n, float f) {
        this.getReel((int)n).currPosition += f;
    }

    public void selectReel(int n, boolean bl) {
        this.getReel((int)n).isSelected = bl;
    }

    protected void paint(Graphics graphics) {
        int n = this.startX;
        int n2 = this.reelsAndSeps.size();
        for (int i = 0; i < n2; ++i) {
            Object e = this.reelsAndSeps.elementAt(i);
            if (e instanceof Reel) {
                n += ((Reel)e).paint(graphics, n);
                continue;
            }
            if (!(e instanceof Image)) continue;
            Image image = (Image)e;
            graphics.drawImage(image, n, 0);
            n += image.getWidth();
        }
    }

    private static int mod(int n, int n2) {
        if ((n %= n2) < 0) {
            n += n2;
        }
        return n;
    }

    private static float mod(float f, int n) {
        if ((f %= (float)n) < 0.0f) {
            f += (float)n;
        }
        return f;
    }

    private final class Reel {
        Image[] unselectedImages;
        Image[] selectedImages;
        int maxWidth;
        int itemCount;
        float currPosition;
        boolean isSelected;

        Reel(Image[] imageArray, Image[] imageArray2) {
            if (imageArray2 != null && imageArray2.length != imageArray.length) {
                throw new IllegalArgumentException();
            }
            this.itemCount = imageArray.length;
            this.unselectedImages = imageArray;
            this.selectedImages = imageArray2;
            int n = 0;
            int n2 = imageArray.length;
            while (--n2 >= 0) {
                if (imageArray[n2] != null && imageArray[n2].getWidth() > n) {
                    n = imageArray[n2].getWidth();
                }
                if (imageArray2 == null || imageArray2[n2] == null || imageArray2[n2].getWidth() <= n) continue;
                n = imageArray2[n2].getWidth();
            }
            this.maxWidth = n;
        }

        int paint(Graphics graphics, int n) {
            Image image;
            int n2;
            int n3 = (int)this.currPosition;
            float f = this.currPosition - (float)n3;
            n3 = SlotMachine.mod(n3, this.unselectedImages.length);
            int n4 = this.unselectedImages[n3].getHeight();
            int n5 = (int)(f * (float)n4);
            short s = graphics.getClipHeight();
            int n6 = n2 = (s - n4 >> 1) - n5;
            int n7 = n3;
            Image image2 = image = this.selectedImages == null || !this.isSelected || n5 != 0 ? this.unselectedImages[n3] : this.selectedImages[n3];
            if (image != null) {
                graphics.drawImage(image, n, n2);
            }
            do {
                n3 = SlotMachine.mod(n3 - 1, this.unselectedImages.length);
                graphics.drawImage(this.unselectedImages[n3], n, n2 -= this.unselectedImages[n3].getHeight());
            } while (n2 + this.unselectedImages[n3].getHeight() >= 0);
            while (n6 < s) {
                n7 = SlotMachine.mod(n7 + 1, this.unselectedImages.length);
                graphics.drawImage(this.unselectedImages[n7], n, n6 += this.unselectedImages[n7].getHeight());
            }
            return this.maxWidth;
        }
    }
}

