/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.ui;

import com.livescribe.display.AttributedText;
import com.livescribe.display.BrowseList;
import com.livescribe.display.Display;
import com.livescribe.display.Displayable;
import com.livescribe.display.Graphics;
import com.livescribe.display.Image;
import com.livescribe.display.Transition;
import com.livescribe.ext.ui.Menu;
import com.livescribe.ui.ScrollLabel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class RadioMenu
extends Menu {
    private static String defaultSelectedImage;
    private static String defaultNotSelectedImage;
    private String selectedImage;
    private String notSelectedImage;
    private Image dotImage;
    private Image emptyDotImage;
    private Vector radioIcons;
    private Display display;
    private int selectedIndex;
    private boolean jumpToSelected = true;

    public static Menu createOnOffMenu(boolean bl, Display display) {
        return new RadioMenu(new String[]{"Off", "On"}, bl ? 1 : 0, display);
    }

    public RadioMenu(String[] stringArray, int n, Display display) {
        if (n < 0 || stringArray.length <= n) {
            throw new IndexOutOfBoundsException("Selected index out of range: " + n);
        }
        this.display = display;
        this.addMenuListener(new MyListener());
        this.radioIcons = new Vector(stringArray.length);
        this.radioIcons.setSize(stringArray.length);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            this.add(stringArray[i]);
            this.setRadioIcon(i, this.loadImage(i == n));
        }
        this.selectedIndex = n;
        this.getBrowseList().setFocusItem(n);
    }

    protected Menu.MenuBrowseList createBrowseList(Vector vector, BrowseList.Title title) {
        return new RadioMenuBrowseList(vector, title);
    }

    public static void setDefaultSelectedImage(String string) {
        defaultSelectedImage = string;
    }

    public static void setDefaultNotSelectedImage(String string) {
        defaultNotSelectedImage = string;
    }

    public synchronized void setSelectedImage(String string) {
        this.selectedImage = string;
        this.dotImage = null;
    }

    public synchronized void setNotSelectedImage(String string) {
        this.notSelectedImage = string;
        this.emptyDotImage = null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setJumpToSelected(boolean bl) {
        this.jumpToSelected = bl;
    }

    private void setRadioIcon(int n, Image image) {
        if (n < 0 || this.getItemCount() <= n) {
            throw new IndexOutOfBoundsException("Index out of range: " + n);
        }
        this.radioIcons.setElementAt(image, n);
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || this.getItemCount() <= n) {
            throw new IndexOutOfBoundsException("Index out of range: " + n);
        }
        if (n != this.selectedIndex) {
            this.setRadioIcon(this.selectedIndex, this.loadImage(false));
            this.selectedIndex = n;
            this.setRadioIcon(n, this.loadImage(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Image loadImage(boolean bl) {
        String string;
        if (bl) {
            if (this.dotImage != null) {
                return this.dotImage;
            }
            string = this.selectedImage == null ? defaultSelectedImage : this.selectedImage;
        } else {
            if (this.emptyDotImage != null) {
                return this.emptyDotImage;
            }
            string = this.notSelectedImage == null ? defaultNotSelectedImage : this.notSelectedImage;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                Image image = Image.createImage((InputStream)inputStream);
                if (bl) {
                    this.dotImage = image;
                } else {
                    this.emptyDotImage = image;
                }
                Image image2 = image;
                return image2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private final class RadioMenuBrowseList
    extends Menu.MenuBrowseList {
        RadioMenuBrowseList(Vector vector, BrowseList.Title title) {
            super(vector, title);
        }

        protected void drawItem(Graphics graphics, BrowseList.Item item, Image image, Object object, int n, int n2) {
            Image image2;
            int n3 = ((Menu.MenuItem)item).getIndex();
            if (0 <= n3 && n3 < RadioMenu.this.radioIcons.size() && (image2 = (Image)RadioMenu.this.radioIcons.elementAt(n3)) != null) {
                graphics.drawImage(image2, n, n2);
                n += image2.getWidth() + 1;
            }
            if (image != null) {
                graphics.drawImage(image, n, n2);
                n += image.getWidth() + 1;
            }
            if (object instanceof String) {
                graphics.drawString((String)object, n, n2, 0);
            } else if (object instanceof AttributedText) {
                graphics.drawString((AttributedText)object, n, n2, 0);
            }
        }

        protected void scrollItem(Graphics graphics, ScrollLabel scrollLabel, BrowseList.Item item, int n, int n2) {
            Object object;
            Image image = item.getIcon();
            int n3 = this.itemModel.indexOf(item);
            if (0 <= n3 && n3 < RadioMenu.this.radioIcons.size() && (object = (Image)RadioMenu.this.radioIcons.elementAt(n3)) != null) {
                graphics.drawImage((Image)object, n, n2);
                n += object.getWidth() + 1;
            }
            if (image != null) {
                graphics.drawImage(image, n, n2);
                n += image.getWidth() + 1;
            }
            object = item.getText();
            short s = (short)(graphics.getClipWidth() - n - this.insets.right);
            int n4 = Display.getHeight() - this.insets.top - this.insets.bottom;
            this.setScrollerClipRegion(scrollLabel, (short)n, (short)this.insets.top, s, (short)n4);
            if (object instanceof String) {
                scrollLabel.draw(null, (String)object, n, n2, (int)s, n4, true);
            } else if (object instanceof AttributedText) {
                scrollLabel.draw((AttributedText)object, null, n, n2, (int)s, n4, true);
            }
        }
    }

    private final class MyListener
    implements Menu.MenuListener {
        private MyListener() {
        }

        public void menuShown(Menu menu) {
        }

        public void itemChanged(Menu menu, int n, int n2, boolean bl) {
            if (bl && RadioMenu.this.jumpToSelected && menu.getFocusIndex() != RadioMenu.this.selectedIndex) {
                menu.setFocusIndex(RadioMenu.this.selectedIndex);
            }
        }

        public void itemSelected(Menu menu, int n) {
            if (RadioMenu.this.selectedIndex != n) {
                RadioMenu.this.setSelectedIndex(n);
                RadioMenu.this.display.setTransition(Transition.DEFAULT);
                RadioMenu.this.display.setCurrent((Displayable)RadioMenu.this.getBrowseList());
            }
        }
    }
}

