/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.ui;

import com.livescribe.buttons.Bookmarkable;
import com.livescribe.display.Transition;
import com.livescribe.event.PenTipEvent;
import com.livescribe.ext.ui.Menu;
import com.livescribe.penlet.AbstractPenletPlugin;
import com.livescribe.penlet.Penlet;
import com.livescribe.ui.MediaPlayer;
import java.util.Hashtable;

public class MenuBookmarkHandlerPlugin
extends AbstractPenletPlugin {
    private Hashtable idMap = new Hashtable();
    private long parentHoldTime = 1000L;
    private String selectAPM;
    private String forwardAPM;
    private MediaPlayer player;

    public MenuBookmarkHandlerPlugin(Penlet penlet) {
        super(penlet, false);
    }

    public void register(Menu menu, int n, Bookmarkable bookmarkable, boolean bl) {
        menu.setBookmarkable(n, bookmarkable);
        if (bookmarkable != null) {
            this.idMap.put(new Integer(bookmarkable.getBookmarkAreaId()), new MenuItemInfo(menu, n, bl));
        }
    }

    public void registerLast(Menu menu, Bookmarkable bookmarkable, boolean bl) {
        this.register(menu, menu.getItemCount() - 1, bookmarkable, bl);
    }

    public void setParentHoldTime(long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.parentHoldTime = l;
    }

    public void setSelectAPM(String string) {
        this.selectAPM = string;
        if (string != null && this.player == null) {
            this.player = MediaPlayer.newInstance((Penlet)this.getPenlet());
        }
    }

    public void setForwardAPM(String string) {
        this.forwardAPM = string;
        if (string != null && this.player == null) {
            this.player = MediaPlayer.newInstance((Penlet)this.getPenlet());
        }
    }

    public boolean onPenTipEvent(PenTipEvent penTipEvent) {
        switch (penTipEvent.getId()) {
            case 100: {
                MenuItemInfo menuItemInfo = (MenuItemInfo)this.idMap.get(new Integer(penTipEvent.getRegion().getAreaId()));
                if (menuItemInfo == null) break;
                if (this.selectAPM != null && this.player != null) {
                    this.player.play(this.selectAPM);
                }
                menuItemInfo.menu.setFocusIndex(menuItemInfo.index);
                menuItemInfo.menu.show(this.getDisplay(), Transition.DEFAULT);
                if (!menuItemInfo.doSelect) break;
                Menu menu = menuItemInfo.menu.getSubmenu(menuItemInfo.index);
                if (menu != null) {
                    if (this.parentHoldTime > 0L) {
                        try {
                            Thread.sleep(this.parentHoldTime);
                        }
                        catch (InterruptedException interruptedException) {
                            return false;
                        }
                    }
                    if (this.forwardAPM != null && this.player != null) {
                        this.player.play(this.forwardAPM);
                    }
                }
                menuItemInfo.menu.doSelect(menuItemInfo.index, this.getDisplay(), null);
            }
        }
        return false;
    }

    private static final class MenuItemInfo {
        Menu menu;
        int index;
        boolean doSelect;

        MenuItemInfo(Menu menu, int n, boolean bl) {
            this.menu = menu;
            this.index = n;
            this.doSelect = bl;
        }
    }
}

