/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.ui;

import com.livescribe.buttons.Bookmarkable;
import com.livescribe.display.AttributedText;
import com.livescribe.display.BrowseList;
import com.livescribe.display.Display;
import com.livescribe.display.Displayable;
import com.livescribe.display.Image;
import com.livescribe.display.Transition;
import com.livescribe.event.MenuEvent;
import com.livescribe.ui.MediaPlayer;
import java.io.InputStream;
import java.util.Vector;

public class Menu {
    private BrowseList browseList;
    private int focusIndex;
    private boolean dontNotifyItemChanged;
    private Vector items;
    private Object title;
    private MenuListener listener;
    private Menu parent;
    private Object metadata;
    private static String defaultBackAPM;
    private static String defaultForwardAPM;
    private static String defaultSelectAPM;
    private String backAPM;
    private String forwardAPM;
    private String selectAPM;
    private boolean playBackAPM = true;
    private boolean playForwardAPM = true;
    private boolean playSelectAPM = true;

    public Menu() {
        this(null);
    }

    public Menu(Object object) {
        Menu.checkText(object);
        this.items = new Vector();
        this.title = object;
        this.focusIndex = object != null ? -1 : 0;
    }

    private static void checkText(Object object) {
        if (object != null && !(object instanceof AttributedText) && !(object instanceof String)) {
            throw new IllegalArgumentException("Bad text type: " + object.getClass().getName());
        }
    }

    public void addMenuListener(MenuListener menuListener) {
        if (this.listener == null) {
            this.listener = menuListener;
        } else if (menuListener != null) {
            this.listener = new ChainedMenuListener(this.listener, menuListener);
        }
    }

    public void removeMenuListener(MenuListener menuListener) {
        if (this.listener != null) {
            if (this.listener == menuListener) {
                this.listener = null;
            } else {
                MenuListener menuListener2 = this.listener;
                ChainedMenuListener chainedMenuListener = null;
                while (menuListener2 instanceof ChainedMenuListener) {
                    ChainedMenuListener chainedMenuListener2 = (ChainedMenuListener)menuListener2;
                    if (chainedMenuListener2.ml2 == menuListener) {
                        if (chainedMenuListener != null) {
                            chainedMenuListener.ml1 = chainedMenuListener2.ml1;
                        } else {
                            this.listener = chainedMenuListener2.ml1;
                        }
                        return;
                    }
                    if (chainedMenuListener2.ml1 == menuListener) {
                        if (chainedMenuListener != null) {
                            chainedMenuListener.ml1 = chainedMenuListener2.ml2;
                        } else {
                            this.listener = chainedMenuListener2.ml2;
                        }
                        return;
                    }
                    menuListener2 = chainedMenuListener2.ml1;
                    chainedMenuListener = chainedMenuListener2;
                }
            }
        }
    }

    public void add(Object object) {
        this.add(object, null, null, null, null);
    }

    public void add(Object object, Menu menu) {
        this.add(object, null, null, null, menu);
    }

    public void add(Object object, MenuAction menuAction) {
        this.add(object, null, null, menuAction, null);
    }

    public void add(Object object, Image image, String string, MenuAction menuAction, Menu menu) {
        if (object == null) {
            throw new NullPointerException();
        }
        Menu.checkText(object);
        int n = this.items.size();
        this.items.addElement(new MenuItem(n, object, image, string, menu != null, menuAction, menu, null));
        this.browseList = null;
        if (menu != null) {
            menu.parent = this;
        }
    }

    public void remove(int n) {
        this.items.removeElementAt(n);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setBookmarkable(int n, Bookmarkable bookmarkable) {
        BrowseList.Item item = (BrowseList.Item)this.items.elementAt(n);
        boolean bl = false;
        if (bookmarkable == null) {
            if (item instanceof BookmarkableMenuItem) {
                item = new MenuItem(n, (BookmarkableMenuItem)item);
                this.items.setElementAt(item, n);
                bl = true;
            }
        } else if (item instanceof BookmarkableMenuItem) {
            ((BookmarkableMenuItem)item).b = bookmarkable;
            bl = true;
        } else {
            item = new BookmarkableMenuItem((MenuItem)item, bookmarkable);
            this.items.setElementAt(item, n);
            bl = true;
        }
        if (bl) {
            this.browseList = null;
        }
    }

    public void setLastItemBookmarkable(Bookmarkable bookmarkable) {
        int n = this.items.size();
        if (n <= 0) {
            return;
        }
        this.setBookmarkable(n - 1, bookmarkable);
    }

    public void setAudio(int n, String string) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        menuItem.audio = string;
    }

    public void setText(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Menu.checkText(object);
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        menuItem.text = object;
    }

    public void setSelectable(int n, boolean bl) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        menuItem.selectable = bl;
    }

    public boolean isSelectable(int n) {
        return ((MenuItem)this.items.elementAt((int)n)).selectable;
    }

    public void setIcon(int n, Image image) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        menuItem.icon = image;
    }

    public static void setDefaultBackAPM(String string) {
        defaultBackAPM = string;
    }

    public static void setDefaultForwardAPM(String string) {
        defaultForwardAPM = string;
    }

    public static void setDefaultSelectAPM(String string) {
        defaultSelectAPM = string;
    }

    public void setBackAPM(String string) {
        this.backAPM = string;
    }

    public void setForwardAPM(String string) {
        this.forwardAPM = string;
    }

    public void setSelectAPM(String string) {
        this.selectAPM = string;
    }

    public void setPlayBackAPM(boolean bl) {
        this.playBackAPM = bl;
    }

    public void setPlayForwardAPM(boolean bl) {
        this.playForwardAPM = bl;
    }

    public void setPlaySelectAPM(boolean bl) {
        this.playSelectAPM = bl;
    }

    public void addAction(int n, final MenuAction menuAction) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        if (menuItem.action == null) {
            menuItem.action = menuAction;
        } else if (menuAction != null) {
            final MenuAction menuAction2 = menuItem.action;
            menuItem.action = new MenuAction(){

                public void execute(Menu menu, int n) {
                    menuAction2.execute(menu, n);
                    menuAction.execute(menu, n);
                }
            };
        }
    }

    public void setOneWayParent(Menu menu) {
        this.parent = menu;
    }

    public void setMetadata(Object object) {
        this.metadata = object;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(int n, Object object) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        menuItem.metadata = object;
    }

    public Object getMetadata(int n) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        return menuItem.metadata;
    }

    public Menu getParent() {
        return this.parent;
    }

    public Menu getSubmenu(int n) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        return menuItem.submenu;
    }

    public void setSubmenu(int n, Menu menu) {
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        menuItem.submenu = menu;
    }

    private static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        AttributedText attributedText = (AttributedText)object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = attributedText.getCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(attributedText.getText(i));
        }
        return stringBuffer.toString();
    }

    protected MenuBrowseList createBrowseList(Vector vector, BrowseList.Title title) {
        return new MenuBrowseList(vector, title);
    }

    protected BrowseList getBrowseList() {
        if (this.browseList == null) {
            BrowseList.Title title = this.title == null ? null : new BrowseList.Title(Menu.toString(this.title), null);
            this.browseList = this.createBrowseList(this.items, title);
        }
        return this.browseList;
    }

    protected void fireItemChanged(int n, int n2, boolean bl) {
        if (this.listener != null) {
            this.listener.itemChanged(this, n, n2, bl);
        }
    }

    protected void fireItemSelected(int n) {
        if (this.listener != null) {
            this.listener.itemSelected(this, n);
        }
    }

    protected void fireMenuShown() {
        if (this.listener != null) {
            this.listener.menuShown(this);
        }
    }

    public void setFocusIndex(int n) {
        if (n < 0 || this.getItemCount() <= n) {
            throw new IndexOutOfBoundsException("Index out of range: " + n);
        }
        int n2 = this.focusIndex;
        this.focusIndex = n;
        this.fireItemChanged(n2, n, false);
    }

    public int getFocusIndex() {
        return this.focusIndex;
    }

    public void show(Display display, Transition transition) {
        Transition transition2 = display.getTransition();
        BrowseList browseList = this.getBrowseList();
        int n = browseList.getFocusIndex();
        if (n != this.focusIndex) {
            this.dontNotifyItemChanged = true;
            browseList.setFocusItem(this.focusIndex);
            this.dontNotifyItemChanged = false;
        }
        this.fireItemChanged(n, this.focusIndex, true);
        display.setTransition(transition);
        display.setCurrent((Displayable)browseList);
        display.setTransition(transition2);
        this.fireMenuShown();
    }

    public Menu doSelect(int n, Display display, MediaPlayer mediaPlayer) {
        MenuAction menuAction;
        MenuItem menuItem = (MenuItem)this.items.elementAt(n);
        if (menuItem.submenu == null && this.playSelectAPM) {
            Menu.play(mediaPlayer, this.selectAPM != null ? this.selectAPM : defaultSelectAPM);
        }
        if ((menuAction = menuItem.action) != null) {
            menuAction.execute(this, n);
        }
        this.fireItemSelected(n);
        Menu menu = menuItem.submenu;
        if (menu != null) {
            if (this.playForwardAPM) {
                Menu.play(mediaPlayer, this.forwardAPM != null ? this.forwardAPM : defaultForwardAPM);
            }
            menu.show(display, Transition.RIGHT_TO_LEFT);
            return menu;
        }
        return this;
    }

    public Menu handleMenuEvent(MenuEvent menuEvent, Display display, MediaPlayer mediaPlayer) {
        BrowseList browseList = this.getBrowseList();
        Menu menu = this;
        switch (menuEvent.getId()) {
            case 85: {
                int n;
                int n2 = browseList.getFocusIndex();
                this.focusIndex = n = browseList.focusToPrevious();
                this.fireItemChanged(n2, n, false);
                break;
            }
            case 68: {
                int n;
                int n3 = browseList.getFocusIndex();
                this.focusIndex = n = browseList.focusToNext();
                this.fireItemChanged(n3, n, false);
                break;
            }
            case 76: {
                Menu menu2 = this.getParent();
                if (menu2 == null) break;
                if (this.playBackAPM) {
                    Menu.play(mediaPlayer, this.backAPM != null ? this.backAPM : defaultBackAPM);
                }
                menu2.show(display, Transition.LEFT_TO_RIGHT);
                menu = menu2;
                break;
            }
            case 82: {
                menu = this.doSelect(this.focusIndex, display, mediaPlayer);
            }
        }
        return menu;
    }

    private static void play(MediaPlayer mediaPlayer, String string) {
        if (mediaPlayer != null && string != null) {
            mediaPlayer.play(string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Menu");
        if (this.title != null) {
            stringBuffer.append('(').append(this.title).append(')');
        }
        stringBuffer.append('[');
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            MenuItem menuItem = (MenuItem)this.items.elementAt(i);
            stringBuffer.append(menuItem.text);
            Menu menu = menuItem.submenu;
            if (menu == null) continue;
            stringBuffer.append('=').append(menu);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static final class ChainedMenuListener
    implements MenuListener {
        MenuListener ml1;
        MenuListener ml2;

        ChainedMenuListener(MenuListener menuListener, MenuListener menuListener2) {
            this.ml1 = menuListener;
            this.ml2 = menuListener2;
        }

        public void itemChanged(Menu menu, int n, int n2, boolean bl) {
            this.ml1.itemChanged(menu, n, n2, bl);
            this.ml2.itemChanged(menu, n, n2, bl);
        }

        public void itemSelected(Menu menu, int n) {
            this.ml1.itemSelected(menu, n);
            this.ml2.itemSelected(menu, n);
        }

        public void menuShown(Menu menu) {
            this.ml1.menuShown(menu);
            this.ml2.menuShown(menu);
        }
    }

    private static final class BookmarkableMenuItem
    extends MenuItem
    implements Bookmarkable {
        private Bookmarkable b;

        BookmarkableMenuItem(MenuItem menuItem, Bookmarkable bookmarkable) {
            super(menuItem.index, menuItem.text, menuItem.icon, menuItem.audio, menuItem.selectable, menuItem.action, menuItem.submenu, menuItem.metadata);
            if (bookmarkable == null) {
                throw new NullPointerException();
            }
            this.b = bookmarkable;
        }

        public int getBookmarkAreaId() {
            return this.b.getBookmarkAreaId();
        }

        public int getBookmarkZOrder() {
            return 0;
        }

        public String getBookmarkDisplayName() {
            return this.b.getBookmarkDisplayName();
        }

        public Displayable getBookmarkDisplayable() {
            return this.b.getBookmarkDisplayable();
        }
    }

    protected static class MenuItem
    implements BrowseList.Item {
        int index;
        Object text;
        Image icon;
        boolean selectable;
        MenuAction action;
        Menu submenu;
        String audio;
        Object metadata;

        MenuItem(int n, Object object, Image image, String string, boolean bl, MenuAction menuAction, Menu menu, Object object2) {
            this.index = n;
            this.text = object;
            this.icon = image;
            this.selectable = bl;
            this.audio = string;
            this.action = menuAction;
            this.submenu = menu;
            this.metadata = object2;
        }

        MenuItem(int n, BookmarkableMenuItem bookmarkableMenuItem) {
            this(n, bookmarkableMenuItem.text, bookmarkableMenuItem.icon, bookmarkableMenuItem.audio, bookmarkableMenuItem.selectable, bookmarkableMenuItem.action, bookmarkableMenuItem.submenu, bookmarkableMenuItem.metadata);
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public Object getText() {
            return this.text;
        }

        public Image getIcon() {
            return this.icon;
        }

        public InputStream getAudioStream() {
            if (this.audio == null) {
                return null;
            }
            return this.getClass().getResourceAsStream(this.audio);
        }

        public String getAudioMimeType() {
            return MediaPlayer.getMimeType((String)this.audio);
        }

        protected int getIndex() {
            return this.index;
        }
    }

    public static interface MenuListener {
        public void itemChanged(Menu var1, int var2, int var3, boolean var4);

        public void itemSelected(Menu var1, int var2);

        public void menuShown(Menu var1);
    }

    public static interface MenuAction {
        public void execute(Menu var1, int var2);
    }

    protected class MenuBrowseList
    extends BrowseList {
        protected MenuBrowseList(Vector vector, BrowseList.Title title) {
            super(vector, title);
        }

        public void setFocusItem(int n) {
            int n2 = Menu.this.focusIndex;
            super.setFocusItem(n);
            Menu.this.focusIndex = n;
            if (!Menu.this.dontNotifyItemChanged) {
                Menu.this.fireItemChanged(n2, n, false);
            }
        }
    }
}

