/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.plugins;

import com.livescribe.afp.PageInstance;
import com.livescribe.display.AttributedText;
import com.livescribe.display.Display;
import com.livescribe.display.Displayable;
import com.livescribe.display.Transition;
import com.livescribe.event.HWRListener;
import com.livescribe.event.PenTipEvent;
import com.livescribe.event.StrokeEvent;
import com.livescribe.ext.util.Log;
import com.livescribe.geom.Rectangle;
import com.livescribe.geom.Shape;
import com.livescribe.icr.ICRContext;
import com.livescribe.icr.Resource;
import com.livescribe.penlet.AbstractPenletPlugin;
import com.livescribe.penlet.Penlet;
import com.livescribe.penlet.PenletStateChangeException;
import com.livescribe.storage.StrokeStorage;
import com.livescribe.ui.ScrollLabel;
import java.util.Vector;

public class AcquireHWPlugin
extends AbstractPenletPlugin {
    private static final String CLASS_NAME = "AcquireHWPlugin";
    public static final int DEFAULT_HWR_INACTIVITY_TIME = 2000;
    private static final int START_STATE = 0;
    private static final int WAIT_FOR_PEN_DOWN_STATE = 1;
    private static final int RUNNING_STATE = 2;
    private static final int FINISHED_STATE = 3;
    public static final int RESULT_UNDEFINED = 0;
    public static final int RESULT_OK = 1;
    public static final int RESULT_OVERLAPPED = 2;
    public static final int RESULT_PAGE_CHANGED = 3;
    public static final int RESULT_HWR_ERROR = 4;
    private ScrollLabel label;
    private int state;
    private final Object lock = new Object();
    private String hwrResult;
    private String hwrErrorString;
    private Rectangle hwrResultBounds;
    private boolean recordNextStroke;
    protected Rectangle currBB;
    protected PageInstance currPage;
    private int hwrInactivityTime = 2000;
    private ICRContext icrContext;
    private HWRListener myHWRListener = new MyHWRListener();
    private Vector akRes;
    private Vector skRes;
    private Vector lkRes;
    private Vector appRes;
    private boolean displayOnResult;
    private DisplayFilter displayFilter;
    private boolean allowOverlap;
    private boolean allowPageChange;
    private boolean doubleTapTerminates;
    private boolean userPauseTerminates;
    private boolean seenDoubleTap;
    private boolean strokePending;
    private int resultStatus;

    public AcquireHWPlugin(Penlet penlet) {
        super(penlet, false);
    }

    public void activate() throws PenletStateChangeException {
        if (this.active) {
            return;
        }
        this.changeState(0);
        if (this.akRes == null && this.skRes == null && this.lkRes == null && this.appRes == null) {
            throw new PenletStateChangeException("ICR resources not set");
        }
        try {
            this.icrContext = this.getPenlet().getContext().getICRContext(this.hwrInactivityTime, this.myHWRListener);
            this.icrContext.addResourceSet(this.createResources(this.icrContext));
        }
        catch (RuntimeException runtimeException) {
            if (this.icrContext != null) {
                this.icrContext.dispose();
                this.icrContext = null;
            }
            throw new PenletStateChangeException((Throwable)runtimeException);
        }
        this.label = new ScrollLabel();
        this.restart(true);
        super.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restart(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.recordNextStroke = true;
            this.resultStatus = 0;
            if (bl) {
                this.resetState();
            }
            this.changeState(1);
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        if (this.icrContext != null) {
            this.icrContext.dispose();
            this.icrContext = null;
        }
        super.deactivate();
    }

    private void changeState(int n) {
        this.state = n;
    }

    public void setHWRInactivityTime(int n) {
        this.hwrInactivityTime = n;
    }

    private Resource[] createResources(ICRContext iCRContext) {
        int n;
        Vector<Resource> vector = new Vector<Resource>(3);
        if (this.akRes != null) {
            for (n = 0; n < this.akRes.size(); ++n) {
                vector.addElement(iCRContext.createAKSystemResource((String)this.akRes.elementAt(n)));
            }
        }
        if (this.skRes != null) {
            for (n = 0; n < this.skRes.size(); ++n) {
                vector.addElement(iCRContext.createSKSystemResource((String)this.skRes.elementAt(n)));
            }
        }
        if (this.lkRes != null) {
            for (n = 0; n < this.lkRes.size(); ++n) {
                vector.addElement(iCRContext.createLKSystemResource((String)this.lkRes.elementAt(n)));
            }
        }
        if (this.appRes != null) {
            for (n = 0; n < this.appRes.size(); ++n) {
                vector.addElement(iCRContext.createAppResource((String)this.appRes.elementAt(n)));
            }
        }
        Object[] objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void addAKSystemResource(String string) {
        if (this.akRes == null) {
            this.akRes = new Vector(2);
        }
        this.akRes.addElement(string);
    }

    public void addSKSystemResource(String string) {
        if (this.skRes == null) {
            this.skRes = new Vector(2);
        }
        this.skRes.addElement(string);
    }

    public void addLKSystemResource(String string) {
        if (this.lkRes == null) {
            this.lkRes = new Vector(2);
        }
        this.lkRes.addElement(string);
    }

    public void addAppResource(String string) {
        if (this.appRes == null) {
            this.appRes = new Vector(2);
        }
        this.appRes.addElement(string);
    }

    public void clearResources() {
        this.appRes = null;
        this.lkRes = null;
        this.skRes = null;
        this.akRes = null;
    }

    public void setAllowOverlap(boolean bl) {
        this.allowOverlap = bl;
    }

    public void setAllowPageChange(boolean bl) {
        this.allowPageChange = bl;
    }

    public void setDisplayOnResult(boolean bl, DisplayFilter displayFilter) {
        this.displayOnResult = bl;
        this.displayFilter = displayFilter;
    }

    public void setDoubleTapTerminates(boolean bl) {
        this.doubleTapTerminates = bl;
    }

    public void setUserPauseTerminates(boolean bl) {
        this.userPauseTerminates = bl;
    }

    public String getResult() {
        return this.hwrResult;
    }

    public Rectangle getResultBounds() {
        return this.hwrResultBounds;
    }

    public int getResultStatus() {
        return this.resultStatus;
    }

    public String getHWRErrorString() {
        return this.hwrErrorString;
    }

    private void drawResult(String string) {
        if (this.displayFilter == null) {
            this.draw(string, false);
        } else {
            this.draw(this.displayFilter.filter(string));
        }
    }

    private void draw(String string, boolean bl) {
        String string2 = bl ? AttributedText.parseEnriched((String)string, null) : string;
        this.draw(string2);
    }

    private void draw(Object object) {
        if (object instanceof AttributedText) {
            this.label.draw((AttributedText)object, true);
        } else {
            this.label.draw(String.valueOf(object), true);
        }
        Display display = this.getPenlet().getContext().getDisplay();
        display.setTransition(Transition.DEFAULT);
        if (display.getCurrent() != this.label) {
            display.setCurrent((Displayable)this.label);
        }
    }

    private void resetState() {
        if (this.icrContext != null) {
            this.icrContext.clearStrokes();
        }
        this.currBB = null;
        this.currPage = null;
        this.hwrResult = null;
        this.hwrResultBounds = null;
        this.seenDoubleTap = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStrokeEvent(StrokeEvent strokeEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (1 == this.state) {
                Log.debug(CLASS_NAME, "onStrokeEvent", "Skipping " + strokeEvent);
                return false;
            }
            this.strokePending = false;
            if (!this.recordNextStroke) {
                if (3 == this.state) {
                    this.deactivate();
                } else {
                    this.recordNextStroke = true;
                }
                return true;
            }
            Log.debug(CLASS_NAME, "onStrokeEvent", "Sending stroke to ICRContext");
            this.icrContext.addStroke(strokeEvent.getPageInstance(), strokeEvent.getTime());
            StrokeStorage strokeStorage = new StrokeStorage(strokeEvent.getPageInstance());
            Rectangle rectangle = strokeStorage.getStrokeBoundingBox(strokeEvent.getTime());
            this.currBB = this.currBB == null ? rectangle : Shape.getUnion((Shape)this.currBB, (Shape)rectangle);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPenTipEvent(PenTipEvent penTipEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (1 == this.state && 100 != penTipEvent.getId()) {
                Log.debug(CLASS_NAME, "onPenTipEvent", "Skipping " + penTipEvent);
                return false;
            }
            if (3 == this.state) {
                return this.active;
            }
            switch (penTipEvent.getId()) {
                case 100: {
                    Log.debug(CLASS_NAME, "onPenTipEvent", "Pen down: region=" + penTipEvent.getRegion() + " page=" + penTipEvent.getPageInstance());
                    if (1 == this.state) {
                        this.changeState(2);
                    }
                    this.strokePending = true;
                    if (this.currPage != null && this.currPage.getPageAddress() != penTipEvent.getPageInstance().getPageAddress() && !this.allowPageChange) {
                        this.resultStatus = 3;
                        this.recordNextStroke = false;
                        this.resetState();
                        this.changeState(3);
                        break;
                    }
                    if (penTipEvent.getRegion().getAreaId() != 0 && !this.allowOverlap) {
                        this.resultStatus = 2;
                        this.recordNextStroke = false;
                        this.resetState();
                        this.changeState(3);
                        break;
                    }
                    this.recordNextStroke = true;
                    Log.debug(CLASS_NAME, "onPenTipEvent", "Sending pen down to ICRContext");
                    this.icrContext.notifyPenDown(penTipEvent.getTime());
                    this.currPage = penTipEvent.getPageInstance();
                    break;
                }
                case 103: {
                    Log.debug(CLASS_NAME, "onPenTipEvent", "Double tap!");
                    if (this.currBB == null || this.currPage == null) break;
                    this.seenDoubleTap = true;
                    if (this.hwrResult != null && this.doubleTapTerminates) {
                        this.changeState(3);
                    }
                    if (!this.doubleTapTerminates) break;
                    return false;
                }
            }
            return true;
        }
    }

    public String toString() {
        return "Acquire HW Plugin";
    }

    private final class MyHWRListener
    implements HWRListener {
        private MyHWRListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hwrResult(long l, String string) {
            Log.debug(AcquireHWPlugin.CLASS_NAME, "hwrResult", "result[" + string.length() + "]=" + string);
            Object object = AcquireHWPlugin.this.lock;
            synchronized (object) {
                AcquireHWPlugin.this.hwrResult = string;
                AcquireHWPlugin.this.resultStatus = 1;
                if (AcquireHWPlugin.this.displayOnResult) {
                    AcquireHWPlugin.this.drawResult(string);
                }
                if (AcquireHWPlugin.this.doubleTapTerminates && AcquireHWPlugin.this.seenDoubleTap) {
                    AcquireHWPlugin.this.changeState(3);
                    if (!AcquireHWPlugin.this.strokePending) {
                        AcquireHWPlugin.this.deactivate();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hwrUserPause(long l, String string) {
            Log.debug(AcquireHWPlugin.CLASS_NAME, "hwrUserPause", "result[" + string.length() + "]=" + string);
            Object object = AcquireHWPlugin.this.lock;
            synchronized (object) {
                AcquireHWPlugin.this.hwrResult = string;
                AcquireHWPlugin.this.hwrResultBounds = AcquireHWPlugin.this.icrContext.getTextBoundingBox();
                AcquireHWPlugin.this.resultStatus = 1;
                if (AcquireHWPlugin.this.displayOnResult) {
                    AcquireHWPlugin.this.drawResult(string);
                }
                if (!AcquireHWPlugin.this.doubleTapTerminates || AcquireHWPlugin.this.seenDoubleTap || AcquireHWPlugin.this.userPauseTerminates) {
                    AcquireHWPlugin.this.changeState(3);
                    if (!AcquireHWPlugin.this.strokePending) {
                        AcquireHWPlugin.this.deactivate();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hwrError(long l, String string) {
            Log.error("AcquireHWPlugin$MyHWRListener", "hwrError", "[" + l + "]: " + string);
            Object object = AcquireHWPlugin.this.lock;
            synchronized (object) {
                AcquireHWPlugin.this.resultStatus = 4;
                AcquireHWPlugin.this.hwrErrorString = string;
                AcquireHWPlugin.this.changeState(3);
                if (!AcquireHWPlugin.this.strokePending) {
                    AcquireHWPlugin.this.deactivate();
                }
            }
        }

        public void hwrCrossingOut(long l, String string) {
        }
    }

    public static interface DisplayFilter {
        public Object filter(String var1);
    }
}

