/*
 * Decompiled with CFR 0.152.
 */
package com.livescribe.ext.io;

import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends InputStream {
    protected volatile InputStream in;
    protected volatile byte[] buf;
    protected int count;
    protected int pos;

    public BufferedInputStream(InputStream inputStream, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size must be > 0");
        }
        this.in = inputStream;
        this.buf = new byte[n];
    }

    private void fill() throws IOException {
        byte[] byArray = this.getBuf();
        int n = this.getIn().read(byArray, 0, byArray.length);
        this.count = Math.max(0, n);
        this.pos = 0;
    }

    private byte[] getBuf() throws IOException {
        byte[] byArray = this.buf;
        if (byArray == null) {
            throw new IOException("Closed");
        }
        return byArray;
    }

    private InputStream getIn() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw new IOException("Closed");
        }
        return inputStream;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBuf()[this.pos++] & 0xFF;
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            if (n2 >= this.getBuf().length) {
                return this.getIn().read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = Math.min(n3, n2);
        System.arraycopy(this.getBuf(), this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream;
        this.getBuf();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 < 0 || byArray.length - (n + n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            int n4;
            if ((n4 = this.readInternal(byArray, n + n3, n2 - n3)) <= 0) {
                return n3 == 0 ? n4 : n3;
            }
            if ((n3 += n4) < n2) continue;
            return n3;
        } while ((inputStream = this.in) == null || inputStream.available() > 0);
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        this.getBuf();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 <= 0L) {
            return this.getIn().skip(l);
        }
        long l3 = Math.min(l2, l);
        this.pos = (int)((long)this.pos + l3);
        return l3;
    }

    public synchronized int available() throws IOException {
        return this.getIn().available() + Math.max(0, this.count - this.pos);
    }

    public void close() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream != null) {
            this.in = null;
            inputStream.close();
        }
    }
}

